<?php
  require("connzara.php"); 

// Include the main TCPDF library (search for installation path).
require_once('tcpdf_include.php');

// extend TCPF with custom functions
class MYPDF extends TCPDF {

	// Load table data from file
	public function LoadData($file) {
		// Read file lines
		$lines = file($file);
		$data = array();
		foreach($lines as $line) {
			$data[] = explode(';', chop($line));
		}
		return $data;
	}

	// Colored table
	public function ColoredTable($header,$data) {
		// Colors, line width and bold font
		$this->SetFillColor(43, 53, 148);
		$this->SetTextColor(255);
		$this->SetDrawColor(128, 0, 0);
		$this->SetLineWidth(0.3);
		$this->SetFont('', 'B');
		// Header
		$w = array(20,120, 40 );
		$num_headers = count($header);
		for($i = 0; $i < $num_headers; ++$i) {
			$this->Cell($w[$i], 7, $header[$i], 1, 0, 'L', 1);
		}
		$this->Ln();
		// Color and font restoration
		$this->SetFillColor(224, 235, 255);
		$this->SetTextColor(0);
		$this->SetFont('');
		// Data
		$fill = 0;
		foreach($data as $row) {
			$this->Cell($w[0], 6, $row[0], 'LR', 0, 'L', $fill);
			$this->Cell($w[1], 6, $row[1], 'LR', 0, 'L', $fill);
			$this->Cell($w[2], 6, $row[2], 'LR', 0, 'L', $fill); 
			$this->Ln();
			$fill=!$fill;
		}
		$this->Cell(array_sum($w), 0, '', 'T');
	}
}

// create new PDF document
$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$queryk=mysqli_query($con,'SELECT COMPANYNAME,concat(PHYSICALADD," Phone ",PHONE1,"\n",email,"  ",WEB)PHYSICALADD   FROM companyinfo c;');
$rowa=mysqli_fetch_array($queryk); 
 
  
 
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Skeva Tech Ltd');
$pdf->SetTitle('Charts of Accounts');
$pdf->SetSubject(' Charts of Accounts');
$pdf->SetSubject(' Charts of Accounts'); 
//$pdf->SetKeywords('TCPDF, PDF, example, test, guide');

// set default header data
$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, $rowa['COMPANYNAME'] , $rowa['PHYSICALADD'], array(0,64,277), array(0,64,128));

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
	require_once(dirname(__FILE__).'/lang/eng.php');
	$pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set font
$pdf->SetFont('helvetica', '', 12);

// add a page
$pdf->AddPage(); 
  
  
 $pdf->Cell(40,10,'Charts of Accounts');  
 $pdf->Ln();  

$data=array();
// column titles
$header = array('Code ','Account Name ', ' Type');
  $where=" where PRID =(select PRID  from payrollrun where PYear='".$_SESSION['PYear']."' and Mn= '".$_SESSION['Pmnth']."')  and   NETPAY>0 "; 
	 if($_SESSION['PYTYPE']!='A')
	 $where=$where." and paymentMethod='".$_SESSION['PYTYPE']."'"; 
	  $query= mysqli_query($con,"SELECT ACNO,CODE,  ACTYPE, trim(CSB)CSB, CDescr ,ACQRY FROM journalref j where ACNO is not Null order by 1,2;"); 
  		 echo mysqli_error($con);
		 $bal=0;
while($row= mysqli_fetch_array($query)) {   //$row['CODE'],
    if($row['CSB']==''){
	 array_push($data,array($row['ACNO'].$row['CODE'],$row['CDescr'],$row['ACTYPE']));
	}else{
	     $kqry=$row['CSB'];
		 $kqry=mysqli_query($con,$kqry);
		 echo mysqli_error($con);
		while($krw=mysqli_fetch_array($kqry)){
		  array_push($data,array($row['ACNO'].$row['CODE'].$krw['code'],$krw['ref2'],$row['ACTYPE']));	
		 }
		
		}
   } 

 
$pdf->ColoredTable($header, $data);
 $pdf->lastPage(); 
 $query=mysqli_query($con,"SELECT pdfnm FROM tblpdfs t;");
 while($row=mysqli_fetch_array($query)){
	 $filename = $row["pdfnm"].".pdf";
 
if (file_exists($filename)) {
     unlink($filename);
}
}
	 
	  mysqli_query($con,"delete from tblpdfs ;");
	  $query=mysqli_query($con,"SELECT date_format((select if(sysuse='T',TrDate,now()) state from systactive),'pdf_%H%i%S') nname FROM dual ;");
	  $row=mysqli_fetch_array($query); 
	  $nname=$_SERVER['SCRIPT_FILENAME'];
	    $base=basename($_SERVER['PHP_SELF']); 
		$nname=str_replace($base,'', $nname); 
	   $nname=$nname.'pdfs/'.$row['nname'];
	  mysqli_query($con,"insert into tblpdfs(pdfnm)values('".$nname."');"); 
     $pdf->Output($nname.".pdf","I");